import { AuthProvider, useAuth } from '@/context/AuthContext';
import { InventoryProvider } from '@/context/InventoryContext';
import { Login } from '@/pages/Login';
import { UserView } from '@/pages/UserView';
import { AdminDashboard } from '@/pages/AdminDashboard';
import './App.css';

function AppContent() {
  const { isAuthenticated, role } = useAuth();

  if (!isAuthenticated) {
    return <Login />;
  }

  if (role === 'admin') {
    return <AdminDashboard />;
  }

  return <UserView />;
}

function App() {
  return (
    <AuthProvider>
      <InventoryProvider>
        <AppContent />
      </InventoryProvider>
    </AuthProvider>
  );
}

export default App;
