-- 39Ricambi Database Schema
-- Run this in your MySQL to set up the database

CREATE DATABASE IF NOT EXISTS 39ricambi CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE 39ricambi;

-- Customer Credentials Table
CREATE TABLE IF NOT EXISTS customer_credentials (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(255) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Products Table
CREATE TABLE IF NOT EXISTS products (
    id VARCHAR(50) PRIMARY KEY,
    category VARCHAR(255) NOT NULL,
    model VARCHAR(500) NOT NULL,
    price DECIMAL(10, 2) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Insert default customer credentials
INSERT INTO customer_credentials (username, password) 
VALUES ('customer', 'screen2024')
ON DUPLICATE KEY UPDATE password = password;

-- Create index for faster searches
CREATE INDEX idx_category ON products(category);
CREATE INDEX idx_model ON products(model);
