# 39Ricambi Backend

Backend API for 39Ricambi Phone Screen Inventory Management System.

## Features

- MySQL database for persistent storage
- REST API for credentials, products, and authentication
- CORS enabled for cross-origin requests
- Secure admin verification

## Setup Instructions

### 1. Install MySQL

**On Ubuntu/Debian:**
```bash
sudo apt update
sudo apt install mysql-server
sudo mysql_secure_installation
```

**On Windows:**
Download and install MySQL from: https://dev.mysql.com/downloads/installer/

### 2. Create Database

```bash
mysql -u root -p < database.sql
```

Or run the SQL commands in `database.sql` in your MySQL client.

### 3. Configure Environment Variables

Copy `.env.example` to `.env` and update with your settings:

```bash
cp .env.example .env
```

Edit `.env`:
```
DB_HOST=localhost
DB_USER=your_mysql_username
DB_PASSWORD=your_mysql_password
DB_NAME=39ricambi
PORT=3001
ADMIN_USERNAME=admin
ADMIN_PASSWORD=admin2024
```

### 4. Install Dependencies

```bash
npm install
```

### 5. Start Server

```bash
npm start
```

For development with auto-reload:
```bash
npm run dev
```

## API Endpoints

### Authentication
- `POST /api/login` - Login (returns role: 'admin' or 'user')

### Credentials
- `GET /api/credentials` - Get current customer credentials
- `POST /api/credentials` - Update customer credentials (admin only)

### Products
- `GET /api/products` - Get all products
- `POST /api/products` - Add new product (admin only)
- `PUT /api/products/:id` - Update product (admin only)
- `DELETE /api/products/:id` - Delete product (admin only)
- `POST /api/products/import` - Bulk import products (admin only)

### Health
- `GET /api/health` - Check server and database status

## Deploying to Namecheap

1. Upload all backend files to a folder (e.g., `/home/username/39ricambi-backend/`)
2. Install Node.js on your server (if not available)
3. Run `npm install`
4. Set up environment variables
5. Start with `npm start` or use PM2 for production:
   ```bash
   npm install -g pm2
   pm2 start server.js --name "39ricambi-api"
   pm2 save
   pm2 startup
   ```

## Frontend Configuration

Update your frontend `.env` file:
```
VITE_API_URL=https://yourdomain.com:3001/api
```

Or if using the same domain with a subdirectory:
```
VITE_API_URL=/api
```
