# 39Ricambi - Complete Deployment Guide

## 📁 Package Contents

This package contains:
1. **Frontend** (`app/`) - React web application
2. **Backend** (`39ricambi-backend/`) - Node.js API with MySQL
3. **Database** (`database.sql`) - MySQL schema

---

## 🗄️ Step 1: Set Up MySQL Database

### Install MySQL (if not already installed)

**Ubuntu/Debian:**
```bash
sudo apt update
sudo apt install mysql-server
sudo mysql_secure_installation
```

**Windows:**
Download from: https://dev.mysql.com/downloads/installer/

### Create Database

```bash
mysql -u root -p < database.sql
```

Or using phpMyAdmin:
1. Create database named `39ricambi`
2. Import `database.sql`

---

## ⚙️ Step 2: Set Up Backend API

### Upload Backend Files

Upload the `39ricambi-backend/` folder to your server, e.g.:
```
/home/username/39ricambi-backend/
```

### Configure Environment Variables

Create `.env` file in `39ricambi-backend/`:

```env
DB_HOST=localhost
DB_USER=your_mysql_username
DB_PASSWORD=your_mysql_password
DB_NAME=39ricambi
PORT=3001
ADMIN_USERNAME=admin
ADMIN_PASSWORD=admin2024
```

### Install Dependencies

```bash
cd /home/username/39ricambi-backend/
npm install
```

### Start the Server

**Option A: Using PM2 (Recommended for production)**
```bash
npm install -g pm2
pm2 start server.js --name "39ricambi-api"
pm2 save
pm2 startup
```

**Option B: Using Node directly**
```bash
node server.js
```

### Test the API

Visit: `http://yourdomain.com:3001/api/health`

Should return: `{"status":"OK","database":"Connected"}`

---

## 🌐 Step 3: Deploy Frontend

### Upload Frontend Files

Upload the contents of `app/dist/` to your web root:
```
/public_html/
  ├── index.html
  ├── .htaccess
  └── assets/
```

### Configure API URL

Edit `app/.env` before building:
```env
VITE_API_URL=https://yourdomain.com:3001/api
```

Or if using the same domain with subdirectory:
```env
VITE_API_URL=/api
```

Then rebuild:
```bash
cd app/
npm run build
```

### .htaccess Configuration

The `.htaccess` file is included for proper SPA routing:
```apache
<IfModule mod_rewrite.c>
  RewriteEngine On
  RewriteBase /
  RewriteRule ^index\.html$ - [L]
  RewriteCond %{REQUEST_FILENAME} !-f
  RewriteCond %{REQUEST_FILENAME} !-d
  RewriteRule . /index.html [L]
</IfModule>
```

---

## 📱 Step 4: Build Android APK

### Prerequisites

1. **Install Android Studio**: https://developer.android.com/studio
2. **Install Java JDK 17**: https://adoptium.net/
3. **Set environment variables**:
   ```bash
   export ANDROID_HOME=$HOME/Android/Sdk
   export PATH=$PATH:$ANDROID_HOME/tools:$ANDROID_HOME/platform-tools
   ```

### Build Steps

1. **Navigate to frontend folder**:
   ```bash
   cd app/
   ```

2. **Build the web app**:
   ```bash
   npm run build
   ```

3. **Add Android platform**:
   ```bash
   npx cap add android
   ```

4. **Sync web assets**:
   ```bash
   npx cap sync
   ```

5. **Open in Android Studio**:
   ```bash
   npx cap open android
   ```

6. **Build APK in Android Studio**:
   - Click `Build` → `Build Bundle(s) / APK(s)` → `Build APK(s)`
   - Or use: `Build` → `Generate Signed Bundle / APK`

### Alternative: Command Line Build

```bash
cd android/
./gradlew assembleDebug
```

APK will be at: `android/app/build/outputs/apk/debug/app-debug.apk`

---

## 🔧 Troubleshooting

### Backend Issues

**Port already in use:**
```bash
# Find process using port 3001
sudo lsof -i :3001
# Kill it
sudo kill -9 <PID>
```

**MySQL connection failed:**
- Check credentials in `.env`
- Ensure MySQL is running: `sudo systemctl status mysql`
- Test connection: `mysql -u root -p`

### Frontend Issues

**API not connecting:**
- Check `VITE_API_URL` in `.env`
- Ensure backend is running
- Check CORS settings in backend

**Blank page after deploy:**
- Verify `.htaccess` exists
- Check file permissions (644 for files, 755 for directories)
- Clear browser cache

### APK Build Issues

**Android Studio not found:**
- Set `CAPACITOR_ANDROID_STUDIO_PATH` environment variable

**Gradle sync failed:**
- Update Android Studio
- Clear Gradle cache: `./gradlew clean`

---

## 🔒 Security Recommendations

1. **Change default admin password** in `.env`
2. **Enable HTTPS** using Let's Encrypt
3. **Use strong MySQL password**
4. **Restrict API access** with firewall rules
5. **Regular backups** of MySQL database

---

## 📞 Support

For issues contact via WhatsApp: wa.me/+393508181116
